#include "mips.h"

.set        noreorder
.set        noat

.text
#CloudMax's Extended Item Action Table
#This will cause the game to load the Item Action Table from 0x803F53F0 instead of 0x803F403C.
.org 0x803D38F0
    lui     v0, 0x803F      #v0 = 0x803F0000
    addu    v0, v0, a0      #v0 = 0x803F0000 + Item ID
    jr      $ra
    lb      v0, 0x53F0(v0)  #v0 = Action ID

#CloudMax's Custom Action Engine Alpha v1.2
#You do not have to touch anything above the functions section.
#I've prepared 2 example actions:
#1 for Iron & Hover Boots (Action ID 43 & 44)
#This function will equip the specified boots, unless you already have them equipped, if that's the case, you will unequip them. It costs 2 magic to use.
#1 for Quiver, Bullet Bag & Bomb Bag (Action ID 45 to 4D)
#This function will turn the items into portable bags with ammo for the 3 different items that when used will give you the amount that specific quiver/bag can carry. It will cost 5 rupees to use.
#
#A basic Action would look something like this:
#customaction1:   
#   #Setup Start (Setup is optional, if item doesn't have any requirements, just skip it)
#   addiu   t1, $zero, 0x0001   #Magic Required: 0x1 (You need at least 1 magic to use the item)
#   addiu   t2, $zero, 0x0001   #Magic Cost: 0x1 (Using the item will cost you 1 magic)
#   addiu   t3, $zero, 0x0001   #Ammo Cost: 0x1 (It cost 1 ammo to use the item. If the item slot doesn't have ammo, it will not be usable)
#   addiu   t4, $zero, 0x0001   #Health Required: 0x1 (You need at least 1 health to use the item)
#   addiu   t5, $zero, 0x0001   #Rupee Cost: 0x1 (It'll cost you 1 rupee to use the item)
#   addiu   t6, $zero, 0x0002   #Restriction: 0x2 (Item can only be used while standing)
#   jal     verify              #Verify that you can use the item
#   NOP
#   #Setup  End
#   ...
#   ASM Code for the specified Action
#   ... 
#   j       end                 #Function is over, jump to end
#   addiu   a1, $zero, 0x0835   #Set sound to play to 0x0835 (Pull out Item)
#

#Function locations
    .org  0x803D6410
        .global return
        return: 
    .org  0x803D2A8C
        .global playsound
        playsound: 
    .org  0x8008E750
        .global msUpdateFunc
        msUpdateFunc: 
    .org  0x80086B9C
        .global setItemBIDFunc
        setItemBIDFunc: 
    .org  0x80031F50
        .global spawnActorFunc
        spawnActorFunc: 
    .org  0x80087330
        .global setItemAmountFunc
        setItemAmountFunc: 


#Is in ovl_player_actor
.org 0x803D63EC
    j start
    NOP
    .global mask
    mask:
    lbu     t0, 0x015F(a3)      #t0 = Current Mask
    addiu   t1, a2, 0xFFC7      #t1 = Mask you're equipping (Action ID-0x39)
    beql    t0, t1, unequip     #Branch likely if the mask you're using the mask you have equipped
        sb      $zero, 0x015F(a3)      #Unequip mask you have equipped
    sb      t1, 0x015F(a3)      #Equip mask you're using
    .global unequip
    unequip:

#Is in custom
.org 0x80500000
.global start
start:
    slti    t0, a2, 0x43        #Set t0 if a2 is less than 0x43
    beq     t0, $zero, setup    #Branch if action is NOT less than 0x43
    NOP                   
    j       mask                #Jump to the Mask function
    NOP
end:
    lw      a0, -0x0004($sp)    #Load the $ra backup
    sw      a0, 0x0014($sp)     #Store $ra where it was initially
    lui     a0, 0x8022          #a0 = 0x80220000
    jal     playsound           #Play sound
    ori     a0, a0, 0x45B0      #a0 = 0x802245B0
    j       return              #
    NOP                         #
    #same?
unusable:
    j       end                 #Jump to End
    addiu   a1, $zero, 0x4806   #Set sound to play to Unusable Item
setup:
    #v1 = 0x8015E660 (SRAM Address)
    #a2 = Action ID
    lw      t1, 0x0014($sp)     #Load the stored $ra from the stack
    sw      t1, -0x0004($sp)    #backup the $ra at a location that won't be touched
    addu    t1, $zero, $zero    #Clear t1 for function setups
    addu    t2, $zero, $zero    #Clear t2 for function setups
    addu    t3, $zero, $zero    #Clear t3 for function setups
    addu    t4, $zero, $zero    #Clear t4 for function setups
    addu    t5, $zero, $zero    #Clear t5 for function setups
    addu    t6, $zero, $zero    #Clear t6 for function setups
    addu    t7, $zero, $zero    #Clear t7 for function setups
    addu    t8, $zero, $zero    #Clear t8 for function setups
    addu    t9, $zero, $zero    #Clear t9 for function setups
    #Used:
    #s0, s2, s3
    #Unused:
    #s1
    J       functions           #Jump to functions
    NOP
verify:
    #$ra = Return Address       Address to return to after verifying the item.
    #t1 = Magic Required        You need atleast this much magic to use it.
    #t2 = Magic Cost            This is the amount of magic it'll cost when using it. This'll be the required amount if it is higher than t1.
    #t3 = Ammo Cost             The amount of Ammo you need to use the item, you'll also loose the same amount. (ONLY WORKS FOR ITEMS WITH AMMO)
    #t4 = Health Required       The amount of health you need to use the item.
    #t5 = Rupee Cost            The amount of rupees it'll cost to use the item.
    #t6 = Restriction           Decides when an item CAN'T be used. 0x1 = Standing, 0x2 = Midair
    #     These bitflags will disable the item even if the button isn't. The default restrictions are still applied. items can't be used from ledges, climbable collision, rolling, etc.
    #t7                         Unused
    #t8                         Unused
    #t9                         Unused
    #v0                         Used for verification
    #v1 = 0x8015E660            SRAM Address
    
    #Check health
    lh      v0, 0x0030(v1)      #v0 = Current Health
    slt     v0, v0, t4          #If (Current Health < Health Required) {v0 = 0x1} Else {v0 = 0x0}
    bne     v0, $zero, unusable #Branch to unusable if you do not have enough health
    NOP
    #t4, v0 is now available
    
    #Check Magic
    lb      v0, 0x0033(v1)      #v0 = Current Magic
    slt     t4, v0, t1          #If (Current Magic < Magic Required) {t4 = 0x1} Else {t4 = 0x0}
    bne     t4, $zero, unusable #Branch to unusable if you do not have enough magic
    NOP
    sub     t1, v0, t2          #t1 = v0 - t2 (New Magic)
    bltz    t1, unusable        #Branch to unusable if you do not have enough magic
    NOP
    #t2, t4, v0 is now unused
    
    #Check Rupees
    lh      v0, 0x0034(v1)      #v0 = Current Rupees
    sub     v0, v0, t5          #v0 = v0 - t5 (New Rupees)
    bltz    v0, unusable        #Branch to unusable if you do not have rupees
    NOP
    sub     t5, $zero, t5       #t5 = -t5 (Rupees to decrease by)
    #t2, t4, v0 is now unused
    
    
    #Get Item Slot
    #To do this, we'll have to read the Last Pressed Item Button Index from 0x801DAB70
    #Then we use that ID to get the item slot linked to the specified button.
    lui     v0, 0x8022          #v0 = Last Pressed Item Button Index Address (Upper Bytes)
    lb      v0, 0x4700(v0)      #v0 = Last Pressed Item Button Index
    addu    v0, v1, v0          #v0 = SRAM + Last Pressed Item Button Index
    lb      v0, 0x006B(v0)      #v0 = Item Slot ID
    #v0 won't be changed for the rest of the verification so that the item slot can be easily accessed later on
    
    #Check Ammunition
    #IF the item requires ammunition, we make sure that the slot ID has a value below 14
    #(so that it won't attempt to read incorrect data, only slot 0-13 has ammo)
    #If the action requires Ammo, but the item slot doesn't have ammo, the item won't be usable in order to prevent data manipulation.
    #If it passes the check we look up how much Ammo the item has and continue like normally.
    beq     t3, $zero, skipammo #We branch past the ammo check if it doesn't cost any ammo
    slti    t2, v0, 0x0014      #If (Item Slot ID < 0x0014) {t2 = 0x1} Else {t2 = 0x0}
    beq     t2, $zero, unusable #Branch to unusable if the Item Slot ID isn't below 14
    NOP
    addu    t2, v1, v0          #t2 = SRAM + Item Slot ID
    lb      t2, 0x008C(t2)      #t2 = Ammo
    sub     t3, t2, t3          #t3 = Ammo - Ammo Cost
    bltz    t3, unusable        #Branch to unusable if you do not have enough ammo
    NOP
    skipammo:
    #t2, t4 is now unused
    
    #Check Restriction
    #0x801DAAB8 = Standing, In Water, Jumping up against ledge, etc. State
    #0x1 = Standing
    #0x60 = In Water?
    beq     t6, $zero, verresqu #There is no restriction, skip past the check
    NOP
    lui     t4, 0x8022          #t4 = standing & in water state (Upper bytes)
    lh      t4, 0x4638(t4)      #t4 = Current standing & in water state
    verresstand:
    andi    t2, t6, 0x0001      #t2 = 0x1 if Standing is restricted
    beq     t2, $zero, verresair#Branch to midair check if standing isn't restricted
    NOP
    andi    t2, t4, 0x0001      #t2 = 0x1 if you're standing
    bne     t2, $zero, unusable #Branch to unusable if you're standing
    NOP
    verresair:
    andi    t2, t6, 0x0002      #t2 = 0x2 if being in midair is restricted
    beq     t2, $zero, verresqu #Branch to restriction check end if being in midair isn't restricted
    NOP
    andi    t2, t4, 0x0001      #t2 = 0x1 if you're standing
    beq     t2, $zero, end      #Branch to end if you're not standing
    addu    a1, $zero, $zero    #Set sound to play to nothing
    verresqu:
    #t2, t4, t6 is now unused

    #Update
    #t1 = New Magic Amount
    #t2 = Unused
    #t3 = New Ammo Amount
    #t4 = Unused
    #t5 = Amount of rupees to decrease by
    #t6 = Unused
    #t7 = Unused
    #t8 = Unused
    #t9 = Unused
    #v0 = Item Slot ID
    #v1 = SRAM Address
    
    sb      t1, 0x0033(v1)      #Current Magic = New Magic Amount
    
    lh      t2, 0x13CC(v1)      #Load current rupee increase/decrease amount
    addu    t2, t2, t5          #Set new rupee increase/decrease amount
    sh      t2, 0x13CC(v1)      #Store new rupeee increase/decrease amount
    
    addu    t2, v1, v0          #t2 = SRAM + Item Slot ID
    sb      t3, 0x008C(t2)      #Current Ammo = New Ammo Amount
    
    jr      $ra                 #Jump Back
    NOP
functions:
    slti    t0, a2, 0x45        #Set t0 if a2 is less than 0x45
    bne     t0, $zero, bootsAct #Branch to boots if action is less than 0x45
    NOP
    slti    t0, a2, 0x4E        #Set t0 if a2 is less than 0x4E
    bne     t0, $zero, refillAct#Branch to refill if action is less than 0x4E
    NOP
    addiu   t0, $zero, 0x4E     #t0 = 0x4E
    beq     a2, t0, escaperopeAct#Branch to escaperope if action is 0x4E
    NOP
    addiu   t0, $zero, 0x4F     #t0 = 0x4F
    beq     a2, t0, testactorAct#Branch to testactor if action is 0x4F
    NOP
    J       end                 #Branch to end if action doesn't exist
    NOP
bootsAct:
    #Setup Start
    addiu   t2, $zero, 0x0002   #Magic Cost: 0x2
    jal     verify              #Verify that you can use the item
    NOP
    #Setup End
    addiu   t0, a2, 0xFFBE      #t0 = a2 - 0x42 = New Boots
    lui     t1, 0x8022          #Boot Type Address (Upper Bytes)
    lb      a1, 0x46FF(t1)      #a1 = Current Boots
    beql    a1, $zero, updatespeed  #Execute Delay Slot and Branch if you don't have any boots equipped
        sb      t0, 0x46FF(t1)  #Current Boots = t0
    sb      $zero, 0x46FF(t1)   #Current Boots = None
    updatespeed:
    ori     a1, t1, 0x45B0      #Required Argument
    jal     msUpdateFunc        #Movement Speed Update Function
    NOP
    j       end                 #Function is over, jump to end
    addiu   a1, $zero, 0x0835   #Set sound to play to Pull out Item
refillAct:   
    #Setup Start 
    addiu   t5, $zero, 0x0005   #Rupee Cost: 0x5
    addiu   t6, $zero, 0x0002   #Item can't be used while in midair
    jal     verify              #Verify that you can use the item
    NOP
    #Setup End
    addiu   t0, a2, 0xFFBC      #t0 = a2 - 0x44 = Type (1 to 9)
    addiu   a1, $zero, 0x0002   #a1 = 0x2
    multu   t0, a1              #LO = t0 * 0x2
    mflo    t1                  #t1 = LO (Offset used to get upgrade size)
    lui     a1, 0x8012          #a1 = 0x80120000 (Capacity Offset Upper Byte)
    or      a1, a1, t1          #a1 = Capacity Global Offset
    sltiu   t1, t0, 0x0004      #If t0 < 0x4 Then t1 = 1 Else t1 = 0
    beql    t1, $zero, quiver   #Branch likely if t0 isn't below 0x4
        sltiu   t1, t0, 0x0007      #If t0 < 0x7 Then t1 = 1 Else t1 = 0
    addiu   a0, $zero, 0x0006   #Slingshot
    j       setammo
    lh      a1, 0x7224(a1)      #a1 = Bullet Bag Capacity Amount
    quiver:
    beq     t1, $zero, bombbag  #Branch likely if t0 isn't below 0x7
    addiu   a0, $zero, 0x0003   #Bow
    j       setammo
    lh      a1, 0x71FC(a1)      #a1 = Quiver Capacity Amount
    bombbag:
    addiu   a0, $zero, 0x0002   #Bomb
    lh      a1, 0x7204(a1)      #a1 = Bomb Bag Capacity Amount
    setammo:
    jal     setItemAmountFunc   #Jump to set Item Amount
    NOP
    lui     a0, 0x8021          #a0 = 0x80210000
    ori     a0, a0, 0x2020      #a0 = 0x80212020 (Required Parameter)
    addiu   a1, $zero, 0x00FF   #a1 = 0xFF (Blank)
    lui     a2, 0x8022          #a2 = Last Pressed Item Button Index Address (Upper Bytes)
    jal     setItemBIDFunc      #Jump to Set Item (Using Button Index)
    lb      a2, 0x4700(a2)      #a2 = Last Pressed Item Button Index
    j       end                     #Function is over, jump to end
    addiu   a1, $zero, 0x0835   #Set sound to play to Pull out Item
escaperopeAct:
    #Setup Start 
    addiu   t6, $zero, 0x0002   #Item can't be used while in midair
    jal     verify              #Verify that you can use the item
    NOP
    #Setup End
    lui     t0, 0x8022          #t0 = 0x8022
    ori     t0, t0, 0x45B0      #t0 = Pointer to links Position
    lwc1    $f4, 0x0024(t0)     #link X Coord
    lwc1    $f8, 0x0028(t0)     #link Z Coord
    lwc1    $f6, 0x002C(t0)     #link Y Coord
    mfc1    a3, $f4             #a3 = $f4 (link X Coord)
    swc1    $f8, 0x0010($sp)    #Stack Var 2 = $f8 (link Z Coord)
    swc1    $f6, 0x0014($sp)    #Stack Var 1 = $f6 (link Y Coord)
    sw      $zero, 0x0018($sp)  #X Rot
    sw      $zero, 0x001C($sp)  #Y Rot
    sw      $zero, 0x0020($sp)  #Z Rot
    addiu   t1, $zero, 0x0001   #Set actor variables to 0x0001
    sw      t1, 0x0024($sp)     #Set actor Variables to t1
    lui     a1, 0x8021          #a0 = 0x80210000
    ori     a0, a1, 0x3C44      #a0 = 0x80213C44 (Required Argument)
    ori     a1, a1, 0x2020      #a1 = 0x80212020 (Required Argument)
    jal     spawnActorFunc      #Jump to Spawn Actorj
    addiu   a2, $zero, 0x009E   #a2 = 0x009E (Farore's Wind)
    addiu   t0, $zero, 0x0014   #t0 = 0x0014
    sb      t0, -0x077B(s0)     #Activate warp
    j       end                 #Function is over, jump to end
    addiu   a1, $zero, 0x087A   #Set sound to play to farore's wind
testactorAct:
    #Setup Start 
    addiu   t3, $zero, 0x0001   #Ammo Cost: 0x1
    jal     verify              #Verify that you can use the item
    NOP
    #Setup End
    lui     t0, 0x8022          #t0 = 0x8022
    ori     t0, t0, 0x45B0      #t0 = Pointer to links Position
    lwc1    $f4, 0x0024(t0)     #link X Coord
    lwc1    $f8, 0x0028(t0)     #link Z Coord
    lwc1    $f6, 0x002C(t0)     #link Y Coord
    mfc1    a3, $f4             #a3 = $f4 (link X Coord)
    swc1    $f8, 0x0010($sp)    #Stack Var 2 = $f8 (link Z Coord)
    swc1    $f6, 0x0014($sp)    #Stack Var 1 = $f6 (link Y Coord)
    sw      $zero, 0x0018($sp)  #X Rot
    sw      $zero, 0x001C($sp)  #Y Rot
    sw      $zero, 0x0020($sp)  #Z Rot
    addiu   t1, $zero, 0x00000  #
    #addiu   t1, $zero, 0x0202   #t1 = 0x0202
    sw      t1, 0x0024($sp)     #Aet Action Variables to t1
    lui     a1, 0x8021          #a0 = 0x80210000
    ori     a0, a1, 0x3C44      #a0 = 0x80213C44 (Required Argument)
    ori     a1, a1, 0x2020      #a1 = 0x80212020 (Required Argument)
    jal     spawnActorFunc      #Jump to Spawn Actor
    addiu   a2, $zero, 0x01A0   #a2 = 0x01A0 (Crate)
    #addiu   a2, $zero, 0x0000   #a2 = 0x0000 (links Actor ID)
    j       end                 #Function is over, jump to end
    addiu   a1, $zero, 0x0835   #Set sound to play to Pull out Item


80223E08 decides which Link you spawn as.
    
    
Spawn Actor
A0 = 80213C44
A1 = 80212020
A2 = Actor ID
Stack = floating point x, y, z position, Half-float x,y,z rotation, actor variable 


#80084D10 receive item